package com.burhanstore.neonbubblequest.Utils.monetize



import android.annotation.SuppressLint
import android.app.Activity
import android.util.Log
import com.applovin.mediation.MaxAd
import com.applovin.mediation.MaxReward
import com.applovin.mediation.MaxRewardedAdListener
import com.applovin.mediation.ads.MaxRewardedAd


@SuppressLint("StaticFieldLeak")
object Applovin_Ad {

    private const val TAG = "Applovin_Ad"
    private var rewardedAd: MaxRewardedAd? = null
    private var adUnitId: String = ""
    private lateinit var activity: Activity
    private var isAdLoaded = false

    private var onAdCompleteCallback: (() -> Unit)? = null
    private var onAdFailedCallback: (() -> Unit)? = null
    private var onAdClickedCallback: (() -> Unit)? = null

    fun initialize(activity: Activity, adUnitId: String) {
        this.activity = activity
        this.adUnitId = adUnitId

        rewardedAd = MaxRewardedAd.getInstance(adUnitId, activity)
        rewardedAd?.setListener(adListener)
        loadAd()
        Log.d(TAG, "AppLovin MAX Rewarded initialized with ID: $adUnitId")
    }

    private val adListener = object : MaxRewardedAdListener {
        override fun onAdLoaded(ad: MaxAd?) {
            Log.d(TAG, "AppLovin Ad Loaded")
            isAdLoaded = true
        }

        override fun onAdLoadFailed(adUnitId: String?, error: com.applovin.mediation.MaxError?) {
            Log.e(TAG, "AppLovin Ad Failed to load: ${error?.message}")
            isAdLoaded = false
            onAdFailedCallback?.invoke()

            // Retry load after 10s
            activity.window?.decorView?.postDelayed({ loadAd() }, 10000)
        }

        override fun onAdDisplayed(ad: MaxAd?) {
            Log.d(TAG, "AppLovin Ad Displayed")
        }

        override fun onAdDisplayFailed(ad: MaxAd?, error: com.applovin.mediation.MaxError?) {
            Log.e(TAG, "AppLovin Ad Display Failed: ${error?.message}")
            onAdFailedCallback?.invoke()
            loadAd()
        }

        override fun onAdClicked(ad: MaxAd?) {
            Log.d(TAG, "AppLovin Ad Clicked")
            onAdClickedCallback?.invoke()
        }

        override fun onAdHidden(ad: MaxAd?) {
            Log.d(TAG, "AppLovin Ad Closed")
            loadAd() // Preload next ad
        }

        override fun onRewardedVideoStarted(ad: MaxAd?) {
            Log.d(TAG, "Rewarded Video Started")
        }

        override fun onRewardedVideoCompleted(ad: MaxAd?) {
            Log.d(TAG, "Rewarded Video Completed")
        }

        override fun onUserRewarded(ad: MaxAd?, reward: MaxReward) {
            Log.d(TAG, "User Rewarded")
            onAdCompleteCallback?.invoke()
        }
    }

    fun loadAd() {
        if (rewardedAd?.isReady == false) {
            rewardedAd?.loadAd()
        }
    }

    fun showAd(
        onAdComplete: () -> Unit = {},
        onAdFailed: (() -> Unit)? = null,
        onAdClicked: (() -> Unit)? = null
    ) {
        onAdCompleteCallback = onAdComplete
        onAdFailedCallback = onAdFailed
        onAdClickedCallback = onAdClicked

        if (rewardedAd?.isReady == true) {
            rewardedAd?.showAd()
        } else {
            Log.w(TAG, "AppLovin Ad not ready, loading again...")
            onAdFailedCallback?.invoke()
            loadAd()
        }
    }

    private fun clearCallbacks() {
        onAdCompleteCallback = null
        onAdFailedCallback = null
        onAdClickedCallback = null
    }
}
